% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkMotifSyntax.R
\name{checkMotifSyntax}
\alias{checkMotifSyntax}
\title{Check motif syntax}
\usage{
checkMotifSyntax(motif, filename)
}
\arguments{
\item{motif}{An amino acid motif in the following format: Locus*##$~##$~##$, where ## identifies a peptide position, and $ identifies an amino acid residue. Motifs can include any number of amino acids.}

\item{filename}{The full file path of the user specified dataset if the user wishes to use their own file, or the pre-bundled Solberg dataset. User provided datasets must be a .dat, .txt, or.csv file, and must conform to the structure and format of the Solberg dataset.}
}
\value{
TRUE if the motif syntax is valid. Otherwise, a vector containing FALSE and an error message is returned.
}
\description{
Checks if motif syntax is valid.
}
\note{
For internal SSHAARP use only.
}
\examples{

#Example with correct motif syntax where user specified dataset is the Solberg dataset
checkMotifSyntax("DRB1*26F~28E~30Y", filename=SSHAARP::solberg_dataset)

#Example with incorrect motif syntax where user specified dataset is the Solberg dataset
checkMotifSyntax("DRB1****26F~28E", filename=SSHAARP::solberg_dataset)
}
