% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCC.R
\name{MCC}
\alias{MCC}
\title{Matthews correlation coefficient}
\usage{
MCC(
  actual = NULL,
  predicted = NULL,
  TP = NULL,
  FN = NULL,
  FP = NULL,
  TN = NULL
)
}
\arguments{
\item{actual}{A vector of actual values (1/0 or TRUE/FALSE)}

\item{predicted}{A vector of prediction values (1/0 or TRUE/FALSE)}

\item{TP}{Count of true positives (correctly predicted 1/TRUE)}

\item{FN}{Count of false negatives (predicted 0/FALSE, but actually 1/TRUE)}

\item{FP}{Count of false positives (predicted 1/TRUE, but actually 0/FALSE)}

\item{TN}{Count of true negatives (correctly predicted 0/FALSE)}
}
\value{
Matthews correlation coefficient.
}
\description{
Compute Matthews correlation coefficient.
}
\details{
Calculate Matthews correlation coefficient.
Provide either:
\itemize{
\item \code{actual} and \code{predicted} or
\item \code{TP}, \code{FN}, \code{FP} and \code{TN}.
}
}
\examples{
actual <-    c(1,1,1,1,1,1,0,0,0,0)
predicted <- c(1,1,1,1,0,0,1,0,0,0)
MCC(actual, predicted)
MCC(TP=4, FN=2, FP=1, TN=3)

}
\references{
Holzmann, H., Klar, B. (2024). Robust performance metrics for imbalanced classification problems.
arXiv:2404.07661. \href{https://arxiv.org/abs/2404.07661}{LINK}
}
