% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogisRayleigh.r
\name{LogisRayleigh}
\alias{LogisRayleigh}
\alias{dlogis.rayleigh}
\alias{plogis.rayleigh}
\alias{qlogis.rayleigh}
\alias{rlogis.rayleigh}
\alias{hlogis.rayleigh}
\title{Logistic-Rayleigh Distribution}
\usage{
dlogis.rayleigh(x, alpha, lambda, log = FALSE)
plogis.rayleigh(q, alpha, lambda, lower.tail = TRUE, log.p = FALSE)
qlogis.rayleigh(p, alpha, lambda, lower.tail = TRUE, log.p = FALSE)
rlogis.rayleigh(n, alpha, lambda)
hlogis.rayleigh(x, alpha, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dlogis.rayleigh}: numeric vector of (log-)densities
  \item \code{plogis.rayleigh}: numeric vector of probabilities
  \item \code{qlogis.rayleigh}: numeric vector of quantiles
  \item \code{rlogis.rayleigh}: numeric vector of random variates
  \item \code{hlogis.rayleigh}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Logistic-Rayleigh distribution.
}
\details{
The Logistic-Rayleigh distribution is parameterized by the parameters
\eqn{\alpha > 0} and \eqn{\lambda > 0}.


The Logistic-Rayleigh distribution has CDF:

\deqn{
F(x; \alpha, \lambda) =
 1 - \frac{1}{{1 + {{\left( {{e^{(\lambda {x^2}/2)}} - 1}
\right)}^\alpha }}}   \, ; \quad x \geq 0.
}

where \eqn{\alpha} and \eqn{\lambda} are the parameters.

The following functions are included:
\itemize{
  \item \code{dlogis.rayleigh()} — Density function
  \item \code{plogis.rayleigh()} — Distribution function
  \item \code{qlogis.rayleigh()} — Quantile function
  \item \code{rlogis.rayleigh()} — Random generation
  \item \code{hlogis.rayleigh()} — Hazard function
}
}
\examples{
x <- seq(0.1, 2.0, 0.2)
dlogis.rayleigh(x, 2.0, 5.0)
plogis.rayleigh(x, 2.0, 5.0)
qlogis.rayleigh(0.5, 2.0, 5.0)
rlogis.rayleigh(10, 2.0, 5.0)
hlogis.rayleigh(x, 2.0, 5.0)

# Data
x <- conductors
# ML estimates
params = list(alpha=2.6967, lambda=0.0291)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = plogis.rayleigh, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qlogis.rayleigh, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dlogis.rayleigh, pfun=plogis.rayleigh, plot=FALSE)
print.gofic(out)

}
\references{
Chaudhary, A.K., & Kumar, V. (2020). 
The Logistic - Rayleigh Distribution with Properties and Applications. 
\emph{International Journal of Statistics and Applied Mathematics}, 
\bold{5(6)}, 12--19. 
\doi{10.22271/maths.2020.v5.i6a.603}
}
