% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogisInvWeibull.r
\name{LogisInvWeibull}
\alias{LogisInvWeibull}
\alias{dlogis.inv.weib}
\alias{plogis.inv.weib}
\alias{qlogis.inv.weib}
\alias{rlogis.inv.weib}
\alias{hlogis.inv.weib}
\title{Logistic Inverse Weibull Distribution}
\usage{
dlogis.inv.weib(x, alpha, beta, lambda, log = FALSE)
plogis.inv.weib(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qlogis.inv.weib(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rlogis.inv.weib(n, alpha, beta, lambda)
hlogis.inv.weib(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dlogis.inv.weib}: numeric vector of (log-)densities
  \item \code{plogis.inv.weib}: numeric vector of probabilities
  \item \code{qlogis.inv.weib}: numeric vector of quantiles
  \item \code{rlogis.inv.weib}: numeric vector of random variates
  \item \code{hlogis.inv.weib}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Logistic Inverse Weibull distribution.
}
\details{
The Logistic Inverse Weibull distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Logistic Inverse Weibull distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad \frac{1}{1+\left(e^{\lambda x^{-\beta}}-1\right)^\alpha} \, ; \, x > 0.
}
 
where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The following functions are included:
\itemize{
  \item \code{dlogis.inv.weib()} — Density function
  \item \code{plogis.inv.weib()} — Distribution function
  \item \code{qlogis.inv.weib()} — Quantile function
  \item \code{rlogis.inv.weib()} — Random generation
  \item \code{hlogis.inv.weib()} — Hazard function
}
}
\examples{
x <- seq(0.1, 2.0, 0.2)
dlogis.inv.weib(x, 2.5, 1.5, 0.1)
plogis.inv.weib(x, 2.5, 1.5, 0.1)
qlogis.inv.weib(0.5, 2.5, 1.5, 0.1)
rlogis.inv.weib(10, 2.5, 1.5, 0.1)
hlogis.inv.weib(x, 2.5, 1.5, 0.1)

# Data
x <- stress31
# ML estimates
params = list(alpha=22.20247, beta=0.34507, lambda=3.74216)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = plogis.inv.weib, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qlogis.inv.weib, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dlogis.inv.weib, pfun=plogis.inv.weib, plot=FALSE)
print.gofic(out)

}
\references{
Chaudhary,A.K., & Kumar, V.(2020). 
A Study on Properties and Goodness-of-Fit of The Logistic Inverse Weibull 
Distribution. \emph{Global Journal of Pure and Applied Mathematics(GJPAM)},
\bold{16(6)},871--889. 
\doi{10.37622/GJPAM/16.6.2020.871-889}
}
