% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_synchrony_dataset.R
\name{create_synchrony_dataset}
\alias{create_synchrony_dataset}
\title{Create Synchrony Data Set}
\usage{
create_synchrony_dataset(data_path, heatmap_condition)
}
\arguments{
\item{data_path}{Include path to neural metric dataset csv or excel file produced by the axis navigator neural metric tool. This path should be written within quotation marks and with respect to the current working directory.}

\item{heatmap_condition}{Include a unique identifier for this neuralMetric dataset's experimental condition, this argument will be used by the MEA_heatmap function to group data.}
}
\value{
A reformatted and filtered neural metric dataset for use in synchrony index analysis.
}
\description{
This function reads in, filters, and reformats neural metric csv files produced by the axis navigator neural metric tool
(Axion Biosystems) for use in synchrony index analysis.
}
\examples{
output_neuralMetric <- create_synchrony_dataset(
                                 data_path = system.file("extdata", "input_neuralMetric.csv",
                                                          package = "MEAanalysis"),
                                 heatmap_condition = "SI_condition_1")
}
