% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMMsolve-class.R
\name{deviance.LMMsolve}
\alias{deviance.LMMsolve}
\title{Deviance of an LMMsolve object}
\usage{
\method{deviance}{LMMsolve}(object, relative = TRUE, includeConstant = TRUE, ...)
}
\arguments{
\item{object}{an object of class LMMsolve}

\item{relative}{Deviance relative conditional or absolute unconditional
(-2*logLik(object))? Default \code{relative = TRUE}.}

\item{includeConstant}{Should the constant in the restricted log-likelihood
be included. Default is \code{TRUE}, as for example in \code{lme4} and SAS.
In \code{asreml} the constant is omitted.}

\item{...}{some methods for this generic require additional arguments.
None are used in this method.}
}
\value{
The deviance of the fitted model.
}
\description{
Obtain the deviance of a model fitted using LMMsolve.
}
\examples{
## Fit model on oats.data
data(oats.data)

## Fit simple model with only fixed effects.
LMM1 <- LMMsolve(fixed = yield ~ rep + gen,
                data = oats.data)

## Obtain deviance.
deviance(LMM1)

}
