% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lopez_ruzicka.R
\name{lopez_ruzicka_sym}
\alias{lopez_ruzicka_sym}
\title{Symmetric Lopez-Ruzicka decomposition}
\usage{
lopez_ruzicka_sym(
  mx1,
  mx2,
  age = (1:length(mx1)) - 1,
  nx = rep(1, length(mx1)),
  sex1 = "t",
  sex2 = sex1,
  closeout = TRUE
)
}
\arguments{
\item{mx1}{numeric vector of the mortality rates (central death rates) for population 1}

\item{mx2}{numeric vector of the mortality rates (central death rates) for population 2}

\item{age}{integer vector of the lower bound of each age group (currently only single ages supported)}

\item{nx}{integer vector of age intervals, default 1.}

\item{sex1}{character either the sex for population 1: Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"})}

\item{sex2}{character either the sex for population 2: Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"}) assumed same as \code{sex1} unless otherwise specified.}

\item{closeout}{logical. Default \code{TRUE}. Shall we use the HMD Method Protocol to close out the \code{ax} and \code{qx} values? See details.}
}
\value{
Numeric vector of contributions by age group that sum to the total difference
in life expectancy between the two mortality schedules.
}
\description{
Implements a symmetric version of the Lopez-Ruzicka decomposition by averaging the results from the forward and reverse directions. That is, \code{lopez_ruzicka_sym(mx1, mx2)} returns
\deqn{
\frac{1}{2} \left( \text{lopez\_ruzicka}(mx1, mx2) - \text{lopez\_ruzicka}(mx2, mx1) \right)
}
This symmetric adjustment ensures that the decomposition is directionally neutral.
}
\details{
This symmetric version gives \strong{numerically identical results} to \code{arriaga_sym()}, \code{chandrasekaran_II()}, and \code{chandrasekaran_III()}.
}
\examples{
a <- 0.001
b <- 0.07
x <- 0:100
mx1 <- a * exp(x * b)
mx2 <- a/2 * exp(x * b)
d <- lopez_ruzicka_sym(mx1, mx2, age = x)

# compare to arriaga_sym()
d2 <- arriaga_sym(mx1, mx2, age = x)
all.equal(d, d2)
}
\references{
\insertRef{Ponnapalli2005}{LEdecomp}
}
\seealso{
\code{\link{lopez_ruzicka}}, \code{\link{arriaga_sym}},
\code{\link{chandrasekaran_II}}, \code{\link{chandrasekaran_III}}
}
