% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{estimate_RWVAR_cp}
\alias{estimate_RWVAR_cp}
\title{Robust parameter estimation (RPE) for univariate time series}
\usage{
estimate_RWVAR_cp(
  data,
  L = 15,
  phiLower = -0.8,
  phiUpper = 0.8,
  sigetaLower = 0,
  sigetaUpper = Inf,
  signuLower = 1e-06,
  signuUpper = Inf,
  num_inis = 20,
  CPs = NULL
)
}
\arguments{
\item{data}{Numeric vector containing the univariate time series
observations \eqn{y_{1:n}}.}

\item{L}{Integer; number of lag differences used in the estimation
(default = 15).}

\item{phiLower, phiUpper}{Numeric; lower and upper bounds for the
autoregressive coefficient \eqn{\phi}.}

\item{sigetaLower, sigetaUpper}{Numeric; lower and upper bounds for
\eqn{\sigma_{\eta}^2}, the random walk innovation variance.}

\item{signuLower, signuUpper}{Numeric; lower and upper bounds for
\eqn{\sigma_{\nu}^2}, the VAR(1) innovation variance.}

\item{num_inis}{Integer; number of initial values of \eqn{\phi} used for
grid search initialization (default = 20).}

\item{CPs}{Optional numeric vector of change point locations (indices).
If provided, differenced data crossing these points are removed to
improve the robustness of the variance estimation in the presence of
structural breaks.}
}
\value{
A list with elements:
\itemize{
  \item `sigeta_est` — Estimated \eqn{\sigma_{\eta}^2}.
  \item `signu_est` — Estimated \eqn{\sigma_{\nu}^2}.
  \item `phi_est` — Estimated autoregressive coefficient \eqn{\phi}.
  \item `inis` — Initial parameter values used in optimization.
}
}
\description{
Implements the robust parameter estimation (RPE) procedure to estimate
the parameters \eqn{\sigma_{\eta}^2}, \eqn{\sigma_{\nu}^2}, and \eqn{\phi}
in the univariate version of the proposed model.
The method is based on minimizing the objective function defined in
\code{\link{objective_func}}, using variance estimates computed from
lagged differences of the data.
}
\details{
For each lag \eqn{l = 1, \ldots, L}, the function computes the variance of
the \eqn{l}-lagged differences
\eqn{z^{(l)}_t = y_{t+l} - y_t} using the median absolute deviation (MAD).
If change points (\code{CPs}) are specified, all differences that overlap
a change point are excluded from the computation. The resulting empirical
variances \eqn{\{v^{(l)}\}_{l=1}^L} are then used to construct the following
optimization problem:
\deqn{\sum_{l=1}^L \left(l\sigma^2_{\eta} +
2\frac{1-\phi^l}{1-\phi^2}\sigma^2_{\nu} - v^{(l)}\right)^2,}
which is solved via bounded optimization using \code{optim()} with the
L-BFGS-B algorithm. Initial parameter values are obtained using
non-negative least squares (NNLS) regression over a grid of \eqn{\phi}
values.
}
\keyword{internal}
