% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_utils.R
\name{Tayapp1G}
\alias{Tayapp1G}
\title{Function for the Taylor-based Monte-Carlo-approximation for one group}
\usage{
Tayapp1G(
  repetitions,
  C,
  MSrootStUpsi,
  CorData,
  MvrH,
  Trace,
  M4,
  L,
  P,
  Q,
  n1,
  Atilde = NULL,
  Jacobi = NULL
)
}
\arguments{
\item{repetitions}{a number specifying the number of runs for the
approximation}

\item{C}{the used hypothesis matrix}

\item{MSrootStUpsi}{the matrix root of the covariance matrix for the Taylor
observations}

\item{CorData}{the calculated correlation matrix}

\item{MvrH}{an auxiliary matrix for the transformation from vectorized
covariances to vectorized correlations}

\item{Trace}{a trace used in the ATS for the test statistic}

\item{M4}{a auxiliary matrix for the transformation from vectorized
covariances to vectorized correlations}

\item{L}{an auxiliary matrix for the transformation from vectorized
covariances to vectorized correlations}

\item{P}{an auxiliary matrix for the transformation from vectorized
covariances to vectorized correlations}

\item{Q}{an auxiliary matrix for the transformation from vectorized
covariances to vectorized correlations}

\item{n1}{the total sample size, a scalar}

\item{Atilde}{an auxiliary matrix for the transformation from row-wise
vectorization}

\item{Jacobi}{the Jacobian matrix of the transformation function applied
for the diagonal vectorized correlation  to diagonalwise vectorization. used
for the transformation function 'subdiagonal_mean_ratio_cor', else NULL}
}
\value{
a matrix containing the values of the Taylor ATS for a number of
repetitions
}
\description{
An auxiliary function to calculate the values for the
Taylor-based Monte-Carlo-approximation for one group. After receiving some
auxiliary matrices and data, the Monte-Carlo observations are generated and
different parts of the final sum are defined. Based on this a number of the
Taylor-based ATS are calculated, where the number can be chosen.
}
\keyword{internal}
