% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projected_normal.R
\name{bi.dist.projected_normal}
\alias{bi.dist.projected_normal}
\title{Samples from a Projected Normal distribution.}
\usage{
bi.dist.projected_normal(
  concentration,
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{concentration}{A numeric vector representing the concentration parameter,
representing the direction towards which the samples are concentrated.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{An optional boolean array to mask observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector used for shaping. When \code{sample=FALSE} (model
building), this is used with `.expand(shape)` to set the distribution's
batch shape. When \code{sample=TRUE} (direct sampling), this is used as
`sample_shape` to draw a raw JAX array of the given shape.}

\item{event}{The number of batch dimensions to reinterpret as event
dimensions (used in model building).}

\item{create_obj}{Logical; If `TRUE`, returns the raw BI distribution
object instead of creating a sample site. This is essential for building
complex distributions like `MixtureSameFamily`.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
- When \code{sample=FALSE}, a BI Projected Normal distribution object (for model building).

 - When \code{sample=TRUE}, a JAX array of samples drawn from the Projected Normal distribution (for direct sampling).

 - When \code{create_obj=TRUE}, the raw BI distribution object (for advanced use cases).
}
\description{
The projected normal distribution arises by taking a multivariate normal vector
\deqn{\mathbf X \sim \mathcal N_n (\mu, \Sigma) } in \deqn{\mathbb R^n}
and projecting it to the unit sphere. This distribution is commonly used
in directional statistics (data on circles or spheres) and supports
asymmetric and even multimodal behaviours depending on parameters.
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.projected_normal(concentration = c(1.0, 3.0, 2.0), sample = TRUE)
}
}
\seealso{
\url{https://num.pyro.ai/en/stable/distributions.html#projectednormal}
}
