% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{coherence_score}
\alias{coherence_score}
\title{Coherence score (prior → posterior alignment improvement)}
\usage{
coherence_score(P, W, L, mult = 3, const = 0.5)
}
\arguments{
\item{P}{Prior matrix (\eqn{T \times K}); rows should sum to 1 (approximately).}

\item{W}{Posterior matrix (\eqn{T \times K}); rows should sum to 1 (approximately).}

\item{L}{Likelihood vector (length \eqn{K}), non-negative and summing to 1.}

\item{mult}{Non-negative multiplier applied to the correlation increment (default \code{3.0}).}

\item{const}{Constant offset in \eqn{[0,1]} (default \code{0.5}).}
}
\value{
Scalar coherence score in \eqn{[0,1]}.
}
\description{
Measures how much the posterior \eqn{W} improves alignment with the
sectoral signal \eqn{L} relative to the prior \eqn{P}. We compute the
correlation increment \eqn{\Delta\rho = \max(0,\rho(W,L)-\rho(P,L))} using
\code{robust_cor} (chooses Pearson/Spearman by larger absolute value), then
map it to \eqn{[0,1]} with \code{mult} and \code{const}:
\deqn{\mathrm{score}=\min\{1,\ \mathrm{const}+\mathrm{mult}\cdot\Delta\rho\}.}
}
\examples{
T <- 6; K <- 4
P <- matrix(runif(T*K), T); P <- P/rowSums(P)
W <- matrix(runif(T*K), T); W <- W/rowSums(W)
L <- runif(K); L <- L/sum(L)
coherence_score(P, W, L)

}
