% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{nsDist3d}
\alias{nsDist3d}
\title{Calculate coordinate-specific distance matrices, only for nearest neighbors
and store in an array}
\usage{
nsDist3d(coords, nID, scale_factor = NULL, isotropic = FALSE)
}
\arguments{
\item{coords}{N x 2 matrix; contains the x-y coordinates of stations.}

\item{nID}{N x k matrix; contains indices of nearest neighbors.}

\item{scale_factor}{Scalar; optional argument for re-scaling the distances.}

\item{isotropic}{Logical; indicates whether distances should be calculated
separately for each coordinate dimension (FALSE) or simultaneously for all
coordinate dimensions (TRUE). \code{isotropic = TRUE} can only be used for
two-dimensional coordinate systems.}
}
\value{
Arrays with nearest neighbor distances in each coordinate
direction.
}
\description{
\code{nsDist3d} generates and returns new 3-dimensional arrays containing
the former dist1_sq, dist2_sq, and dist12 matrices, but
only as needed for the k nearest-neighbors of each location.
these 3D matrices (dist1_3d, dist2_3d, and dist12_3d)
are used in the new implementation of calculateAD_ns().
}
\examples{
# Generate some coordinates and neighbors
coords <- cbind(runif(100),runif(100))
nID <- determineNeighbors(coords, 10)
# Calculate distances
nsDist3d(coords, nID)

}
