% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchical_importance.R
\name{hierarchical_importance}
\alias{hierarchical_importance}
\alias{plot.hierarchical_importance}
\title{Calculates importance of hierarchically grouped aspects}
\usage{
hierarchical_importance(
  x,
  data,
  y = NULL,
  predict_function = predict,
  type = "predict",
  new_observation = NULL,
  N = 1000,
  loss_function = DALEX::loss_root_mean_square,
  B = 10,
  fi_type = c("raw", "ratio", "difference"),
  clust_method = "complete",
  cor_method = "spearman",
  ...
)

\method{plot}{hierarchical_importance}(
  x,
  absolute_value = FALSE,
  show_labels = TRUE,
  add_last_group = TRUE,
  axis_lab_size = 10,
  text_size = 3,
  ...
)
}
\arguments{
\item{x}{a model to be explained.}

\item{data}{dataset
NOTE: Target variable shouldn't be present in the \code{data}}

\item{y}{true labels for \code{data}}

\item{predict_function}{predict function}

\item{type}{if \code{predict} then aspect_importance is used, if
\code{model} than feature_importance is calculated}

\item{new_observation}{selected observation with columns that corresponds to
variables used in the model, should be without target variable}

\item{N}{number of rows to be sampled from data
NOTE: Small \code{N} may cause unstable results.}

\item{loss_function}{a function that will be used to assess variable
importance, if \code{type = model}}

\item{B}{integer, number of permutation rounds to perform on each variable
in feature importance calculation, if \code{type = model}}

\item{fi_type}{character, type of transformation that should be applied for
dropout loss, if \code{type = model}. "raw" results raw drop losses,
"ratio" returns \code{drop_loss/drop_loss_full_model}.}

\item{clust_method}{the agglomeration method to be used, see
\code{\link[stats]{hclust}} methods}

\item{cor_method}{the correlation method to be used see 
\code{\link[stats]{cor}} methods}

\item{...}{other parameters}

\item{absolute_value}{if TRUE, aspects importance values will be drawn as
absolute values}

\item{show_labels}{if TRUE, plot will have annotated axis Y}

\item{add_last_group}{if TRUE, plot will draw connecting line between last
two groups}

\item{axis_lab_size}{size of labels on axis Y, if applicable}

\item{text_size}{size of labels annotating values of aspects importance}
}
\value{
ggplot
}
\description{
This function creates a tree that shows order of feature grouping and
calculates importance of every newly created aspect.
}
\examples{
library(DALEX)
apartments_num <- apartments[,unlist(lapply(apartments, is.numeric))]
apartments_num_lm_model <- lm(m2.price ~ ., data = apartments_num)
hi <- hierarchical_importance(x = apartments_num_lm_model,
 data = apartments_num[,-1],
 y = apartments_num[,1],
 type = "model")
plot(hi, add_last_group = TRUE, absolute_value = TRUE)

}
