% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops.R
\name{ops_nms}
\alias{ops_nms}
\title{Performs non-maximum suppression (NMS) on the boxes}
\usage{
ops_nms(boxes, scores, iou_threshold)
}
\arguments{
\item{boxes}{\code{Tensor[N,4]} boxes to perform NMS on. They are expected to be
in \verb{(x1, y1, x2, y2)} format with \verb{0 <= x1 < x2} and \verb{0 <= y1 < y2}.}

\item{scores}{\code{Tensor[N]} scores for each one of the boxes.}

\item{iou_threshold}{\code{float} discards all overlapping boxes with \code{IoU > iou_threshold}.}
}
\value{
int64 tensor with the indices of the elements that have been kept by NMS,
sorted in decreasing order of scores
}
\description{
Performs non-maximum suppression (NMS) on the boxes according to their
intersection-over-union (IoU).
}
\details{
NMS iteratively removes lower scoring boxes which have an IoU greater than
\code{iou_threshold} with another (higher scoring) box.

If multiple boxes have the exact same score and satisfy the IoU criterion with
respect to a reference box, the selected box is not guaranteed to be the same
between CPU and GPU. This is similar to the behavior of argsort in PyTorch
when repeated values are present.
}
\examples{
if (torchvisionlib_is_installed()) {
  ops_nms(torch::torch_rand(3, 4), torch::torch_rand(3), 0.5)
}
}
\concept{ops}
