% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_isclose}
\alias{torch_isclose}
\title{Isclose}
\usage{
torch_isclose(self, other, rtol = 1e-05, atol = 1e-08, equal_nan = FALSE)
}
\arguments{
\item{self}{(Tensor) first tensor to compare}

\item{other}{(Tensor) second tensor to compare}

\item{rtol}{(float, optional) relative tolerance. Default: 1e-05}

\item{atol}{(float, optional) absolute tolerance. Default: 1e-08}

\item{equal_nan}{(bool, optional) if \code{TRUE}, then two \code{NaN} s will be
considered equal. Default: \code{FALSE}}
}
\description{
Isclose
}
\section{isclose(input, other, rtol=1e-05, atol=1e-08, equal_nan=FALSE) -> Tensor }{


Returns a new tensor with boolean elements representing if each element of
\code{input} is "close" to the corresponding element of \code{other}.
Closeness is defined as:

\deqn{
    \vert \mbox{input} - \mbox{other} \vert \leq \mbox{atol} + \mbox{rtol} \times \vert \mbox{other} \vert
}

where \code{input} and \code{other} are finite. Where \code{input}
and/or \code{other} are nonfinite they are close if and only if
they are equal, with NaNs being considered equal to each other when
\code{equal_nan} is TRUE.
}

\examples{
if (torch_is_installed()) {

torch_isclose(torch_tensor(c(1., 2, 3)), torch_tensor(c(1 + 1e-10, 3, 4)))
torch_isclose(torch_tensor(c(Inf, 4)), torch_tensor(c(Inf, 6)), rtol=.5)
}
}
