% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_lm.R
\name{type_lm}
\alias{type_lm}
\title{Linear model plot type}
\usage{
type_lm(se = TRUE, level = 0.95)
}
\arguments{
\item{se}{logical. If TRUE, confidence intervals are drawn.}

\item{level}{the confidence level required.}
}
\description{
Type function for plotting a linear model fit.
Arguments are passed to \code{\link[stats]{lm}}.
}
\examples{
# "lm" type convenience string
tinyplot(Sepal.Width ~ Petal.Width, data = iris, type = "lm")

# Grouped model fits (here: illustrating an example of Simpson's paradox)
tinyplot(Sepal.Width ~ Petal.Width | Species, data = iris, type = "lm")
tinyplot_add(type = "p")

# Use `type_lm()` to pass extra arguments for customization
tinyplot(Sepal.Width ~ Petal.Width, data = iris, type = type_lm(level = 0.8))
}
