% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choices_labeled.R
\name{choices_labeled}
\alias{choices_labeled}
\alias{print.choices_labeled}
\title{Set "\verb{<choice>:<label>}" type of names}
\usage{
choices_labeled(choices, labels, subset = NULL, types = NULL)

\method{print}{choices_labeled}(x, ...)
}
\arguments{
\item{choices}{(\code{character} or \code{factor} or \code{numeric} or \code{logical}) vector.}

\item{labels}{(\code{character}) vector containing labels to be applied to \code{choices}.
If \code{NA} then "Label Missing" will be used.}

\item{subset}{(\code{character} or \code{factor} or \code{numeric} or \code{logical}) vector that
is a subset of \code{choices}.
This is useful if only a few variables need to be named.
If this argument is used, the returned vector will match its order.}

\item{types}{(\code{character}) vector containing the types of the columns to be used for applying the appropriate
icons to the \link{choices_selected} drop down box (e.g. "numeric").}

\item{x}{an object used to select a method.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Named \code{character} vector.
}
\description{
This is often useful for \code{\link[=choices_selected]{choices_selected()}} as it marks up the drop-down boxes
for \code{\link[shiny:selectInput]{shiny::selectInput()}}.
}
\details{
If either \code{choices} or \code{labels} are factors, they are coerced to character.
Duplicated elements from \code{choices} get removed.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(choices_labeled)}: Print choices_labeled object

}}
\examples{
library(teal.data)
library(shiny)

ADSL <- rADSL
ADTTE <- rADTTE

choices1 <- choices_labeled(names(ADSL), col_labels(ADSL, fill = FALSE))
choices2 <- choices_labeled(ADTTE$PARAMCD, ADTTE$PARAM)

# if only a subset of variables are needed, use subset argument
choices3 <- choices_labeled(
  names(ADSL),
  col_labels(ADSL, fill = FALSE),
  subset = c("ARMCD", "ARM")
)

ui <- bslib::page_fluid(
  selectInput("c1",
    label = "Choices from ADSL",
    choices = choices1,
    selected = choices1[1]
  ),
  selectInput("c2",
    label = "Choices from ADTTE",
    choices = choices2,
    selected = choices2[1]
  ),
  selectInput("c3",
    label = "Arm choices from ADSL",
    choices = choices3,
    selected = choices3[1]
  )
)
server <- function(input, output) {}

if (interactive()) {
  shinyApp(ui, server)
}
}
