% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_&_Write_Data.R
\name{Create_CellBender_Merged_Seurat}
\alias{Create_CellBender_Merged_Seurat}
\title{Create Seurat Object with Cell Bender and Raw data}
\usage{
Create_CellBender_Merged_Seurat(
  raw_cell_bender_matrix = NULL,
  raw_counts_matrix = NULL,
  raw_assay_name = "RAW",
  min_cells = deprecated(),
  min_features = deprecated(),
  min.cells = 5,
  min.features = 200,
  ...
)
}
\arguments{
\item{raw_cell_bender_matrix}{matrix file containing the cell bender correct counts.}

\item{raw_counts_matrix}{matrix file contain the uncorrected Cell Ranger (or other) counts.}

\item{raw_assay_name}{a key value to use specifying the name of assay.  Default is "RAW".}

\item{min_cells}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} soft-deprecated. See \code{min.cells}.}

\item{min_features}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} soft-deprecated. See \code{min.features}.}

\item{min.cells}{value to supply to min.cells parameter of \code{\link[SeuratObject]{CreateSeuratObject}}.
Default is 5.}

\item{min.features}{value to supply to min.features parameter of \code{\link[SeuratObject]{CreateSeuratObject}}.
Default is 200.}

\item{...}{Extra parameters passed to \code{\link[SeuratObject]{CreateSeuratObject}}.}
}
\value{
A Seurat Object contain both the Cell Bender corrected counts ("RNA" assay) and uncorrected
counts ("RAW" assay; or other name specified to \code{raw_assay_name}).
}
\description{
Enables easy creation of Seurat object which contains both cell bender data and raw count data as
separate assays within the object.
}
\examples{
\dontrun{
seurat_obj <- Create_CellBender_Merged_Seurat(raw_cell_bender_matrix = cb_matrix,
raw_counts_matrix = cr_matrix)
}

}
\concept{read_&_write}
