% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cut_seasons}
\alias{cut_seasons}
\title{Get season from date time object}
\usage{
cut_seasons(
  datetime,
  definition = "meteorological",
  hemisphere = "northern",
  labels = NULL
)
}
\arguments{
\item{datetime}{a POSIXct vector from with the season is constructed}

\item{definition}{the definition used to compute the season. See details section.}

\item{hemisphere}{in the Southern hemisphere, seasons are reversed compared to the Northern one.}

\item{labels}{optional, a character vector of length fours with the seasons' names.}
}
\value{
a Factor vector with 4 levels depending on the definitions (and labels if provided)
}
\description{
Get season from date time object
}
\details{
Available Definitions:
\itemize{
\item meteorological: Standard seasons (Dec-Feb = Winter, etc.)
\item astronomical: Based on equinoxes/solstices
\item djf: Dec-Jan-Feb, Mar-Apr-May, Jun-Jul-Aug, Sep-Oct-Nov
\item jfm: Jan-Feb-Mar, Apr-May-Jun, Jul-Aug-Sep, Oct-Nov-Dec
\item fma: Feb-Mar-Apr, May-Jun-Jul, Aug-Sep-Oct, Nov-Dec-Jan
\item amj, jas, ond: Alternative starting points for quarterly seasons
}
}
\examples{
dates = seq(from = as.POSIXct("2023-01-15"),
            to = as.POSIXct("2023-12-15"),
            by = "month")
cut_seasons(dates)
}
