% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diary_functions.R
\name{corp_ml}
\alias{corp_ml}
\title{\code{corp_ml} decomposes correlations from multilevel data into within-group
and between-group correlations as well as adds significance symbols to the
end of each value. The workhorse of the function is
\code{\link[psych]{statsBy}}. \code{corp_ml} is simply a combination of
\code{\link{cor_ml}} and \code{\link{add_sig_cor}}.}
\usage{
corp_ml(
  data,
  vrb.nm,
  grp.nm,
  use = "pairwise.complete.obs",
  method = "pearson",
  digits = 3L,
  p.10 = "",
  p.05 = "*",
  p.01 = "**",
  p.001 = "***",
  lead.zero = FALSE,
  trail.zero = TRUE,
  plus = FALSE,
  diags = FALSE,
  lower = TRUE,
  upper = FALSE
)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variable columns.}

\item{grp.nm}{character vector of length 1 of a colname from \code{data}
specifying the grouping column.}

\item{use}{character vector of length 1 specifying how to handle missing
values when computing the correlations. The options are: 1)
"pairwise.complete.obs" which uses pairwise deletion, 2) "complete.obs"
which uses listwise deletion, and 3) "everything" which uses all cases and
returns NA for any correlations from columns in \code{data[vrb.nm]} with
missing values.}

\item{method}{character vector of length 1 specifying which type of
correlations to compute. The options are: 1) "pearson" for traditional
Pearson product-moment correlations, 2) "kendall" for Kendall rank
correlations, and 3) "spearman" for Spearman rank correlations.}

\item{digits}{integer vector of length 1 specifying the number of decimals to
round to.}

\item{p.10}{character vector of length 1 specifying which symbol to append to
the end of any correlation significant at the p < .10 level.}

\item{p.05}{character vector of length 1 specifying which symbol to append to
the end of any correlation significant at the p < .05 level.}

\item{p.01}{character vector of length 1 specifying which symbol to append to
the end of any correlation significant at the p < .01 level.}

\item{p.001}{character vector of length 1 specifying which symbol to append
to the end of any correlation significant at the p < .001 level.}

\item{lead.zero}{logical vector of length 1 specifying whether to retain a
zero in front of the decimal place.}

\item{trail.zero}{logical vector of length 1 specifying whether to retain
zeros after the decimal place (due to rounding).}

\item{plus}{logical vector of length 1 specifying whether to include a plus
sign in front of positive correlations (minus signs are always in front of
negative correlations).}

\item{diags}{logical vector of length 1 specifying whether to retain the
values in the diagonal of the correlation matrix. If TRUE, then the
diagonal will be 1s with \code{digits} number of zeros after the decimal
place (and no significant symbols). If FALSE, then the diagonal will be NA.}

\item{lower}{logical vector of length 1 specifying whether to retain the
lower triangle of the correlation matrix. If TRUE, then the lower triangle
correlations and their significance symbols are retained. If FAlSE, then
the lower triangle will all be NA.}

\item{upper}{logical vector of length 1 specifying whether to retain the
upper triangle of the correlation matrix. If TRUE, then the upper triangle
correlations and their significance symbols are retained. If FAlSE, then
the upper triangle will all be NA.}
}
\value{
list of two elements that are data.frames with names "within" and
  "between". The first data.frame has the within-group correlations with
  their significance symbols at the end of the statistically significant
  correlations based on their associated p-value. The second data.frame has
  the between-group correlations with their significance symbols at the end
  of the statistically significant correlations based on their associated
  p-values. The rownames and colnames of each dataframe are \code{vrb.nm}.
  The formatting of the two data.frames depends on several of the arguments.
}
\description{
\code{corp_ml} decomposes correlations from multilevel data into within-group
and between-group correlations as well as adds significance symbols to the
end of each value. The workhorse of the function is
\code{\link[psych]{statsBy}}. \code{corp_ml} is simply a combination of
\code{\link{cor_ml}} and \code{\link{add_sig_cor}}.
}
\examples{

# traditional use
tmp <- c("outcome","case","session","trt_time") # roxygen2 does not like c() inside []
dat <- as.data.frame(lmeInfo::Bryant2016)[tmp]
stats_by <- psych::statsBy(dat, group = "case") # requires you to include "case" column in dat
corp_ml(data = dat, vrb.nm = c("outcome","session","trt_time"), grp.nm = "case")

# varying the `use` and `method` arguments
corp_ml(data = airquality, vrb.nm = c("Ozone","Solar.R","Wind","Temp"), grp.nm = "Month",
   use = "pairwise", method = "pearson")
corp_ml(data = airquality, vrb.nm = c("Ozone","Solar.R","Wind","Temp"), grp.nm = "Month",
   use = "complete", method = "kendall")
corp_ml(data = airquality, vrb.nm = c("Ozone","Solar.R","Wind","Temp"), grp.nm = "Month",
   use = "everything", method = "spearman")

}
\seealso{
\code{\link{cor_ml}} for multilevel correlations without significance symbols,
   \code{\link{corp_by}} for correlations with significance symbols by group,
   \code{\link[psych]{statsBy}} the workhorse for the \code{corp_ml} function,
   \code{\link{add_sig_cor}} for adding significant symbols to correlation matrices,
}
