% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{singleABC}
\alias{singleABC}
\title{Parameter estimation with Approximate Bayesian Computation for a single
target}
\usage{
singleABC(target, params, sumstats, limits, tol, method)
}
\arguments{
\item{target}{a vector with the target summary statistics. These are usually
computed from observed data or selected from a random simulation when
performing cross-validation.}

\item{params}{is a vector or matrix of simulated parameter values i.e.
numbers from the simulations. Each row or vector entry should be a
different simulation and each column of a matrix should be a different
parameter. This is the dependent variable for the regression, if a
regression step is performed.}

\item{sumstats}{is a vector or matrix of simulated summary statistics. Each
row or vector entry should be a different simulation and each column of a
matrix should be a different statistic. These act as the independent
variables if a regression step is performed.}

\item{limits}{is a matrix with two columns and as many rows as there are
parameters. Each row should contain the minimum value of the prior for a
given parameter in the first column and the maximum value in the second
column.}

\item{tol}{is the tolerance rate, indicating the required proportion of
points accepted nearest the target values.}

\item{method}{either "rejection" or "regression" indicating whether a
regression step should be performed during ABC parameter estimation.}
}
\value{
the returned object is a list containing the following components:

\item{unadjusted}{parameter estimates obtained with the rejection
sampling.}

\item{rej.prediction}{point estimates of the posterior obtained with the
rejection sampling.}

\item{adjusted}{regression adjusted parameter values.}

\item{loc.prediction}{point estimates of the regression adjusted
posterior.}

\item{ss}{set of accepted summary statistics from the simulations.}

\item{wt}{regression weights.}
}
\description{
Perform multivariate parameter estimation based on summary statistics using
an Approximate Bayesian Computation (ABC) algorithm. This function always
uses a rejection sampling algorithm while a local linear regression algorithm
might or might not be used.
}
\details{
To use this function, the usual steps of ABC parameter estimation have to be
performed. Briefly, data should have been simulated based on random draws
from the prior distributions of the parameters of interest and a set of
summary statistics should have been calculated from that data. The same set
of summary statistics should have been calculated from the observed data to
be used as the \code{target} input in this function. Parameter values are accepted
if the Euclidean distance between the set of summary statistics computed from
the simulated data and the set of summary statistics computed from the
observed data is sufficiently small. The percentage of accepted simulations
is determined by \code{tol}. This function performs a simple rejection by calling
the \code{\link[=rejABC]{rejABC()}} function.

When \code{method} is "regression", a local linear regression method is used to
correct for the imperfect match between the summary statistics computed from
the simulated data and the summary statistics computed from the observed
data. The output of the \code{\link[=rejABC]{rejABC()}} function is used as the input of the
\code{\link[=regABC]{regABC()}} function to apply this correction. The parameter values accepted
in the rejection step are weighted by a smooth function (kernel) of the
distance between the simulated and observed summary statistics and corrected
according to a linear transformation.
}
\examples{
# load the matrix with parameter values
data(params)
# load the matrix with simulated parameter values
data(sumstats)
# load the matrix with the prior limits
data(limits)

# select a random simulation to act as target just to test the function
target <- sumstats[10 ,]
# we should remove the random simulation from the sumstats and params matrices
sumstats <- sumstats[-10, ]; params <- params[-10, ]

# parameter estimation for a single target
singleABC(target = target, params = params, sumstats = sumstats, limits = limits,
tol = 0.01, method = "regression")

}
