% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgInfo.R
\name{pkg_cache}
\alias{pkg_cache}
\title{Queries the Package Cache}
\usage{
pkg_cache(pkgs = NULL)
}
\arguments{
\item{pkgs}{A vector of package names to retrieve cache information about.
Default is NULL, which means to return all packages in the cache.}
}
\value{
An data frame showing the package name and latest package
version stored in the cache.  If the package is not stored in the cache,
the package version will be NA.  The "Last Update" time stamp is the
last day and time the cache was updated.
}
\description{
The \code{pkg_cache} function queries the package cache, and
returns information on which packages are included in the cache.
The function also returns the last version of the package cached.
}
\details{
The \strong{pkgdiff} cache is used to speed up \strong{pkgdiff} functions.
Information about each package is pre-processed and stored in the cache
on Github.  The functions then retrieve this pre-processed information
instead of pulling packages down from CRAN.  To learn more about the cache,
refer to \code{vignette('pkgdiff-cache')}.
}
\examples{
# View single package
pkg_cache("dplyr")
# # A package cache object
# - Last Update: 2025-02-25 14:58 UTC
# - Packages:
#   Package Version
# 1   dplyr   1.1.4

# View multiple packages
pkgs <- c("dplyr", "tidyr", "stringr")
pkg_cache(pkgs)
# # A package cache object
# - Last Update: 2025-02-25 14:58 UTC
# - Packages:
#   Package Version
# 1   dplyr   1.1.4
# 2   tidyr   1.3.1
# 3 stringr   1.5.1

# Get all packages
res <- pkg_cache()

# View first 10
res[1:10, ]
# A package cache object
# - Last Update: 2025-02-25 14:58 UTC
# - Packages:
#        Package Version
# 1           A3   1.0.0
# 2   abbreviate     0.1
# 3     abc.data     1.1
# 4          abc   2.2.2
# 5  ABCanalysis   1.2.1
# 6          abd   0.2-8
# 7        abind   1.4-8
# 8      acepack   1.6.1
# 9       actuar   3.3-5
# 10         ada   2.0-5
}
\seealso{
Other pdiff: 
\code{\link{pkg_diff}()},
\code{\link{pkg_info}()},
\code{\link{pkg_stability}()},
\code{\link{pkg_versions}()},
\code{\link{print.pcache}()},
\code{\link{print.pdiff}()},
\code{\link{print.pdiff_score}()},
\code{\link{print.pinfo}()}
}
\concept{pdiff}
