% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_utils.R
\name{util_map_player_id}
\alias{util_map_player_id}
\title{Retrieve a player id from the name}
\usage{
util_map_player_id(x, map = getOption("nhlapi_player_map"))
}
\arguments{
\item{x}{\code{character(1)} a player's name, not case
sensitive for convenience.}

\item{map}{\code{data.frame}, with 2 columns:
\itemize{
\item \code{nameMd5}: \code{character()} of hashed player names
\item \code{id}: \code{integer()} of player ids used by the NHL API
}}
}
\value{
\code{integer(1)}, id of the player or \code{NA_integer}
if not found.
}
\description{
Using a table of hashed names and
ids, get a player id based on the name.
}
\examples{
  nhlapi:::util_map_player_id(
   "Joe Sakic",
   data.frame(
     nameMd5 = "9d2a915c8610dbc524c1bc800e010fcc",
     id = 19L,
     stringsAsFactors = FALSE
   )
 )
}
