% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hydro.R
\name{get_huc}
\alias{get_huc}
\title{Find WBD HUC unit subsets}
\usage{
get_huc(AOI = NULL, id = NULL, t_srs = NULL, buffer = 0.5, type = "huc12")
}
\arguments{
\item{AOI}{sf (MULTI)POINT or (MULTI)POLYGON. An 'area of interest' can
be provided as either a location (sf POINT) or area (sf POLYGON)
in any Spatial Reference System.}

\item{id}{WBD HUC ID(s)}

\item{t_srs}{character (PROJ string or EPSG code) or numeric (EPSG code).
A user specified - target -Spatial Reference System (SRS/CRS) for returned objects.
Will default to the CRS of the input AOI if provided, and to 4326 for ID requests.}

\item{buffer}{numeric. The amount (in meters) to buffer a POINT AOI by for an
extended search. Default = 0.5}

\item{type}{character. Type of feature to return
('huc02', 'huc04', 'huc06', 'huc08', 'huc10', 'huc12', 'huc12_nhdplusv2').

Pulls `huc02`-`huc12` from a web service that hosts a snapshot of the
Watershed Boundary Dataset from October, 2020.

See <doi:10.5066/P92U7ZUT> for full source data.

See https://api.water.usgs.gov/fabric/pygeoapi for the web service.

`huc12_nhdplusv2` derives from a snapshot of the WBD available from the nhdplusv2.
See \link{download_nhdplusv2} for source data documentation.}
}
\value{
a simple features (sf) object
}
\description{
Subsets WBD features by location (POINT),
area (POLYGON), or set of HUC IDs.
}
\details{
The returned object(s) will have the same
Spatial Reference System (SRS) as the input AOI. If a individual or set of
IDs are used to query, then the default server CRS of EPSG:4326 is
preserved. In all cases, a user-defined SRS can be passed to \code{t_srs}
which will override all previous SRS (either input or default).
All buffer and distance operations are handled internally using an
EPSG:5070 Albers Equal Area projection
}
