% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock-dir.R
\name{with_mock_dir}
\alias{with_mock_dir}
\title{Use or create mock files depending on their existence}
\usage{
with_mock_dir(dir, expr, simplify = TRUE, replace = TRUE)
}
\arguments{
\item{dir}{character string, unique folder name that will be used or created
under \verb{tests/testthat/}}

\item{expr}{Code to run inside the fake context}

\item{simplify}{logical: if \code{TRUE} (default), JSON responses with status 200
will be written as just the text of the response body. In all other cases,
and when \code{simplify} is \code{FALSE}, the "response" object will be written out to
a .R file using \code{\link[base:dput]{base::dput()}}.}

\item{replace}{Logical: should the mock directory replace current mock
directories? Default is \code{TRUE}.}
}
\description{
This context will switch the \code{\link[=.mockPaths]{.mockPaths()}} to \code{tests/testthat/dir}
(and then resets it to what it was before).
If the \code{tests/testthat/dir} folder doesn't exist, \code{\link[=capture_requests]{capture_requests()}} will
be run to create mocks.
If it exists, \code{\link[=with_mock_api]{with_mock_api()}} will be run.
To re-record mock files, simply delete \code{tests/testthat/dir} and run the test.
}
