// (c) The HDF Group
#ifndef H5RSprivate_H
#define H5RSprivate_H
#include "H5private.h"
typedef struct H5RS_str_t H5RS_str_t;
H5_DLL H5RS_str_t *H5RS_create(const char *s);
H5_DLL H5RS_str_t *H5RS_wrap(const char *s);
H5_DLL herr_t      H5RS_decr(H5RS_str_t *rs);
H5_DLL herr_t      H5RS_incr(H5RS_str_t *rs);
H5_DLL H5RS_str_t *H5RS_dup(H5RS_str_t *s);
H5_DLL herr_t      H5RS_asprintf_cat(H5RS_str_t *rs, const char *fmt, ...);
H5_DLL herr_t      H5RS_acat(H5RS_str_t *rs, const char *s);
H5_DLL herr_t      H5RS_ancat(H5RS_str_t *rs, const char *s, size_t len);
H5_DLL herr_t      H5RS_aputc(H5RS_str_t *rs, int c);
H5_DLL int         H5RS_cmp(const H5RS_str_t *rs1, const H5RS_str_t *rs2);
H5_DLL size_t      H5RS_len(const H5RS_str_t *rs);
H5_DLL char       *H5RS_get_str(const H5RS_str_t *rs);
H5_DLL unsigned    H5RS_get_count(const H5RS_str_t *rs);
#endif
