// (c) The HDF Group
#ifndef H5Aprivate_H
#define H5Aprivate_H
#include "H5Apublic.h"
#include "H5Gprivate.h"
#include "H5Oprivate.h"
#include "H5Sprivate.h"
#include "H5Tprivate.h"
typedef struct H5A_t H5A_t;
typedef herr_t (*H5A_lib_iterate_t)(const H5A_t *attr, void *op_data);
typedef enum H5A_attr_iter_op_type_t {
#ifndef H5_NO_DEPRECATED_SYMBOLS
    H5A_ATTR_OP_APP,
#endif
    H5A_ATTR_OP_APP2,
    H5A_ATTR_OP_LIB
} H5A_attr_iter_op_type_t;
typedef struct H5A_attr_iter_op_t {
    H5A_attr_iter_op_type_t op_type;
    union {
#ifndef H5_NO_DEPRECATED_SYMBOLS
        H5A_operator1_t app_op;
#endif
        H5A_operator2_t   app_op2;
        H5A_lib_iterate_t lib_op;
    } u;
} H5A_attr_iter_op_t;
H5_DLL herr_t            H5A_init(void);
H5_DLL struct H5O_loc_t *H5A_oloc(H5A_t *attr);
H5_DLL H5G_name_t       *H5A_nameof(H5A_t *attr);
H5_DLL H5T_t            *H5A_type(const H5A_t *attr);
H5_DLL hid_t             H5A_get_space(H5A_t *attr);
H5_DLL herr_t            H5O_attr_iterate_real(hid_t loc_id, const H5O_loc_t *loc, H5_index_t idx_type,
                                               H5_iter_order_t order, hsize_t skip, hsize_t *last_attr,
                                               const H5A_attr_iter_op_t *attr_op, void *op_data);
#endif
