% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text-to-speech.R
\name{gl_talk_shiny}
\alias{gl_talk_shiny}
\title{Speak in Shiny module (server)}
\usage{
gl_talk_shiny(
  input,
  output,
  session,
  transcript,
  ...,
  autoplay = TRUE,
  controls = TRUE,
  loop = FALSE,
  keep_wav = FALSE
)
}
\arguments{
\item{input}{shiny input}

\item{output}{shiny output}

\item{session}{shiny session}

\item{transcript}{The (reactive) text to talk}

\item{...}{
  Arguments passed on to \code{\link[=gl_talk]{gl_talk}}
  \describe{
    \item{\code{languageCode}}{The language of the voice as a \code{BCP-47} language code}
    \item{\code{name}}{Name of the voice, see list via \link{gl_talk_languages} for supported voices.  Set to \code{NULL} to make the service choose a voice based on \code{languageCode} and \code{gender}.}
    \item{\code{gender}}{The gender of the voice, if available}
    \item{\code{audioEncoding}}{Format of the requested audio stream}
    \item{\code{speakingRate}}{Speaking rate/speed between \code{0.25} and \code{4.0}}
    \item{\code{pitch}}{Speaking pitch between \code{-20.0} and \code{20.0} in semitones.}
    \item{\code{volumeGainDb}}{Volumne gain in dB}
    \item{\code{sampleRateHertz}}{Sample rate for returned audio}
    \item{\code{inputType}}{Choose between \code{text} (the default) or SSML markup. The \code{input} text must be SSML markup if you choose \code{ssml}}
    \item{\code{effectsProfileIds}}{Optional. An identifier which selects 'audio effects' profiles that are applied on (post synthesized) text to speech. Effects are applied on top of each other in the order they are given}
  }}

\item{autoplay}{passed to the HTML audio player - default \code{TRUE} plays on load}

\item{controls}{passed to the HTML audio player - default \code{TRUE} shows controls}

\item{loop}{passed to the HTML audio player - default \code{FALSE} does not loop}

\item{keep_wav}{keep the generated wav files if TRUE.}
}
\description{
Call via \code{shiny::callModule(gl_talk_shiny, "your_id")}
}
