% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{scale_color_flexoki_d}
\alias{scale_color_flexoki_d}
\alias{scale_fill_flexoki_d}
\alias{scale_colour_flexoki_d}
\title{Discrete 'Flexoki' Color Scales for \code{ggplot2}}
\usage{
scale_color_flexoki_d(palette = "dark", which = NULL, ..., reverse = FALSE)

scale_fill_flexoki_d(palette = "dark", which = NULL, ..., reverse = FALSE)

scale_colour_flexoki_d(palette = "dark", which = NULL, ..., reverse = FALSE)
}
\arguments{
\item{palette}{palette from \code{names(flexoki)} to use}

\item{which}{numeric indices of colors to use. \code{NULL} by default.}

\item{...}{arguments passed on to \code{ggplot2::discrete_scale()}}

\item{reverse}{Should the vector be reversed? Default is \code{FALSE}.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Scale}
}
\description{
Discrete 'Flexoki' Color Scales for \code{ggplot2}
}
\examples{
ggplot2::mpg |>
  ggplot2::ggplot() +
  ggplot2::geom_point(ggplot2::aes(displ, hwy, colour = class)) +
  scale_color_flexoki_d(palette = 'dark')

ggplot2::mpg |>
  ggplot2::ggplot() +
  ggplot2::geom_point(ggplot2::aes(displ, hwy, fill = class),
    pch = 23, color = 'transparent'
  ) +
  scale_fill_flexoki_d(palette = 'light')

}
