% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eda-bbmk-test.R
\name{eda_bbmk_test}
\alias{eda_bbmk_test}
\title{Block-Bootstrap Mann-Kendall Test for Trend Detection}
\usage{
eda_bbmk_test(data, alpha = 0.05, samples = 10000L)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{alpha}{Numeric scalar in \eqn{[0.01, 0.1]}. The significance
level for confidence intervals or hypothesis tests. Default is 0.05.}

\item{samples}{Integer scalar. The number of bootstrap samples. Default is 10000.}
}
\value{
A list containing the test results, including:
\itemize{
\item \code{data}: The \code{data} argument.
\item \code{alpha}: The significance level as specified in the \code{alpha} argument.
\item \code{null_hypothesis}: A string describing the null hypothesis.
\item \code{alternative_hypothesis}: A string describing the alternative hypothesis.
\item \code{statistic}: The Mann-Kendall S-statistic computed on the original series.
\item \code{bootstrap}: Vector of bootstrapped Mann-Kendall test statistics.
\item \code{p_value}: Empirical two-sided p-value derived from the bootstrap distribution.
\item \code{bounds}: Empirical confidence interval bounds from the bootstrap distribution.
\item \code{reject}: If \code{TRUE}, the null hypothesis was rejected at significance \code{alpha}.
}
}
\description{
Performs a bootstrapped version of the Mann-Kendall trend test to adjust
for serial correlation in annual maximum series data. The BBMK test uses
Spearman’s serial correlation test to identify the least insignificant lag,
then applies a shuffling procedure to obtain the empirical p-value and confidence
bounds for the Mann-Kendall test statistic.
}
\details{
The block size for reshuffling is equal to the \code{least_lag} as estimated in
\code{\link[=eda_spearman_test]{eda_spearman_test()}}. Bootstrap samples are generated by resampling blocks
of the original data \emph{without replacement}. This procedure effectively removes
serial correlation from the data.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
eda_bbmk_test(data, samples = 1000L)

}
\references{
Bayazit, M., 2015. Nonstationarity of hydrological records and recent trends in trend
analysis: a state-of-the-art review. Environmental Processes 2 (3), 527–542.
\doi{10.1007/s40710-015-0081-7}

Khaliq, M.N., Ouarda, T.B.M.J., Gachon, P., Sushama, L., St-Hilaire, A., 2009.
Identification of hydrological trends in the presence of serial and cross correlations:
a review of selected methods and their application to annual flow regimes of Canadian
rivers. Journal Hydrolology 368 (1–4), 117–130. \doi{10.1016/j.jhydrol.2009.01.035}

Sonali, P., Nagesh Kumar, D., 2013. Review of trend detection methods and their
application to detect temperature changes in India. Journal Hydrology 476, 212–227.
\doi{10.1016/j.jhydrol.2012.10.034}
}
\seealso{
\code{\link[=plot_bbmk_test]{plot_bbmk_test()}}, \code{\link[=eda_mk_test]{eda_mk_test()}}, \code{\link[=eda_spearman_test]{eda_spearman_test()}}
}
