% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-geomet.R
\name{data_geomet}
\alias{data_geomet}
\title{Fetch Data from MSC GeoMet API}
\usage{
data_geomet(station_id)
}
\arguments{
\item{station_id}{A character scalar containing the ID of a hydrological monitoring station.
You can search for station IDs by name, province, drainage basin, and location
\href{https://wateroffice.ec.gc.ca/search/real_time_e.html}{here}.}
}
\value{
A dataframe with two columns:
\itemize{
\item \code{max}: A float, the annual maximum series observation, in m\eqn{^3}{^3}/s.
\item \code{year}: An integer, the corresponding year.
}
}
\description{
Gets annual maximum series data for a hydrological monitoring
station from the MSC GeoMet API.
}
\examples{
# Get data for the BOW RIVER AT BANFF (05BB001)
df <- data_geomet("05BB001")

}
\seealso{
\code{\link[=data_local]{data_local()}}
}
