% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns_api.R
\docType{class}
\name{ColumnsApi}
\alias{ColumnsApi}
\title{Columns operations}
\format{An \code{R6Class} generator object}
\description{
factset.analyticsapi.engines.Columns
}
\section{Methods}{

\describe{
\strong{ GetPAColumnById } \emph{ Get PA column settings }
This endpoint returns the default settings of a PA column.

\itemize{
\item \emph{ @param } id character
\item \emph{ @returnType } \link{Column} \cr

\item On encountering errors, an error of subclass ApiException will be thrown.

\item status code : 200 | Expected response, returns settings of a PA column.

\item return type : Column 
\item response headers :

\tabular{ll}{
X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
Age \tab Standard HTTP header. Header will specify the age of columns list cached response. \cr
X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
}
\item status code : 400 | Invalid column Id.


\item response headers :

\tabular{ll}{
X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
}
\item status code : 401 | Missing or invalid authentication.


\item response headers :

\tabular{ll}{
X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
}
\item status code : 403 | User is forbidden with current credentials


\item response headers :

\tabular{ll}{
X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
}
\item status code : 404 | Column not found.


\item response headers :

\tabular{ll}{
X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
}
\item status code : 406 | Unsupported Accept header. Header needs to be set to application/json.


\item response headers :

\tabular{ll}{
X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
}
\item status code : 500 | Server error. Log the X-DataDirect-Request-Key header to assist in troubleshooting.


\item response headers :

\tabular{ll}{
X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
}
\item status code : 503 | Request timed out. Retry the request in sometime.


\item response headers :

\tabular{ll}{
X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
}
}

\strong{ GetPAColumns } \emph{ Get PA columns }
This endpoint lists all the PA columns that can be applied to a calculation.

\itemize{
\item \emph{ @param } name character
\item \emph{ @param } category character
\item \emph{ @param } directory character
\item \emph{ @returnType } named list( \link{ColumnSummary} ) \cr

\item On encountering errors, an error of subclass ApiException will be thrown.

\item status code : 200 | Expected response, returns a list of PA columns

\item return type : map(ColumnSummary) 
\item response headers :

\tabular{ll}{
X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
Age \tab Standard HTTP header. Header will specify the age of columns list cached response. \cr
X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
}
\item status code : 401 | Missing or invalid authentication.


\item response headers :

\tabular{ll}{
X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
}
\item status code : 403 | User is forbidden with current credentials


\item response headers :

\tabular{ll}{
X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
}
\item status code : 406 | Unsupported Accept header. Header needs to be set to application/json.


\item response headers :

\tabular{ll}{
X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
}
\item status code : 500 | Server error. Log the X-DataDirect-Request-Key header to assist in troubleshooting


\item response headers :

\tabular{ll}{
X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
}
\item status code : 503 | Request timed out. Retry the request in sometime.


\item response headers :

\tabular{ll}{
X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
}
}

}
}

\examples{
\dontrun{
####################  GetPAColumnById  ####################

library(factset.analyticsapi.engines)
var.id <- 'id_example' # character | Unique identifier for a column

#Get PA column settings
api.instance <- ColumnsApi$new()

#Configure HTTP basic authorization: Basic
# provide your username in the user-serial format
api.instance$apiClient$username <- '<user-serial>'; 
# provide your api key generated using the developer portal
api.instance$apiClient$password <- '<api_key>';

result <- tryCatch(
            api.instance$GetPAColumnById(var.id),
            ApiException = function(ex) ex 
         )
# In case of error, print the error object 
if(!is.null(result$ApiException)) {
  cat(result$ApiException$toString())
} else {
# deserialized response object
response.object <- result$content
# response headers
response.headers <- result$response$headers
# response status code
response.status.code <- result$response$status_code
}


####################  GetPAColumns  ####################

library(factset.analyticsapi.engines)
var.name <- 'name_example' # character | 
var.category <- 'category_example' # character | 
var.directory <- 'directory_example' # character | 

#Get PA columns
api.instance <- ColumnsApi$new()

#Configure HTTP basic authorization: Basic
# provide your username in the user-serial format
api.instance$apiClient$username <- '<user-serial>'; 
# provide your api key generated using the developer portal
api.instance$apiClient$password <- '<api_key>';

result <- tryCatch(
            api.instance$GetPAColumns(name=var.name, category=var.category, 
                                      directory=var.directory),
            ApiException = function(ex) ex 
         )
# In case of error, print the error object 
if(!is.null(result$ApiException)) {
  cat(result$ApiException$toString())
} else {
# deserialized response object
response.object <- result$content
# response headers
response.headers <- result$response$headers
# response status code
response.status.code <- result$response$status_code
}


}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{apiClient}}{Handles the client-server communication.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ColumnsApi$new()}}
\item \href{#method-GetPAColumnById}{\code{ColumnsApi$GetPAColumnById()}}
\item \href{#method-GetPAColumnByIdWithHttpInfo}{\code{ColumnsApi$GetPAColumnByIdWithHttpInfo()}}
\item \href{#method-GetPAColumns}{\code{ColumnsApi$GetPAColumns()}}
\item \href{#method-GetPAColumnsWithHttpInfo}{\code{ColumnsApi$GetPAColumnsWithHttpInfo()}}
\item \href{#method-clone}{\code{ColumnsApi$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ColumnsApi$new(apiClient)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GetPAColumnById"></a>}}
\subsection{Method \code{GetPAColumnById()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ColumnsApi$GetPAColumnById(id, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GetPAColumnByIdWithHttpInfo"></a>}}
\subsection{Method \code{GetPAColumnByIdWithHttpInfo()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ColumnsApi$GetPAColumnByIdWithHttpInfo(id, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GetPAColumns"></a>}}
\subsection{Method \code{GetPAColumns()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ColumnsApi$GetPAColumns(name = NULL, category = NULL, directory = NULL, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GetPAColumnsWithHttpInfo"></a>}}
\subsection{Method \code{GetPAColumnsWithHttpInfo()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ColumnsApi$GetPAColumnsWithHttpInfo(
  name = NULL,
  category = NULL,
  directory = NULL,
  ...
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ColumnsApi$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
