% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_from_factor.R
\name{one_hot_encoder}
\alias{one_hot_encoder}
\title{One hot encoder}
\usage{
one_hot_encoder(
  data_set,
  encoding = NULL,
  type = "integer",
  verbose = TRUE,
  drop = FALSE
)
}
\arguments{
\item{data_set}{Matrix, data.frame or data.table}

\item{encoding}{Result of function \code{\link{build_encoding}}, (list, default to NULL). \cr
To perform the same encoding on train and test, it is recommended to compute \code{\link{build_encoding}}
before. If it is kept to NULL, build_encoding will be called.}

\item{type}{What class of columns is expected? "integer" (0L/1L), "numeric" (0/1), or "logical" (TRUE/FALSE),
(character, default to "integer")}

\item{verbose}{Should the function log (logical, default to TRUE)}

\item{drop}{Should \code{cols} be dropped after generation (logical, default to FALSE)}
}
\value{
\code{data_set} edited by \strong{reference} with new columns.
}
\description{
Transform factor column into 0/1 columns with one column per values of the column.
}
\details{
If you don't want to edit your data set consider sending \code{copy(data_set)} as an input.\cr
Please \strong{be careful} using this function, it will generate as many columns as there different values
in your column and might use a lot of RAM. To be safe, you can use parameter
 \code{min_frequency} in \code{\link{build_encoding}}.
}
\examples{
data(tiny_messy_adult)

# Compute encoding
encoding <- build_encoding(tiny_messy_adult, cols = c("marital", "occupation"), verbose = TRUE)

# Apply it
tiny_messy_adult <- one_hot_encoder(tiny_messy_adult, encoding = encoding, drop = TRUE)

# Apply same encoding to adult
data(adult)
adult <- one_hot_encoder(adult, encoding = encoding, drop = TRUE)

# To have encoding as logical (TRUE/FALSE), pass it in type argument
data(adult)
adult <- one_hot_encoder(adult, encoding = encoding, type = "logical", drop = TRUE)
}
