% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct-helpers.R
\name{compare_options}
\alias{compare_options}
\title{Options for waldo::compare}
\usage{
compare_options(
  ignore_srcref = TRUE,
  ignore_attr = FALSE,
  ignore_function_env = FALSE,
  ignore_formula_env = FALSE
)
}
\arguments{
\item{ignore_srcref}{Ignore differences in function \code{srcref}s? \code{TRUE} by
default since the \code{srcref} does not change the behaviour of a function,
only its printed representation.}

\item{ignore_attr}{Ignore differences in specified attributes?
Supply a character vector to ignore differences in named attributes.
By default the \code{"waldo_opts"} attribute is listed in \code{ignore_attr} so
that changes to it are not reported; if you customize \code{ignore_attr}, you
will probably want to do this yourself.

For backward compatibility with \code{all.equal()}, you can also use \code{TRUE},
to all ignore differences in all attributes. This is not generally
recommended as it is a blunt tool that will ignore many important
functional differences.}

\item{ignore_function_env, ignore_formula_env}{Ignore the environments of
functions and formulas, respectively? These are provided primarily for
backward compatibility with \code{all.equal()} which always ignores these
environments.}
}
\value{
A list
}
\description{
Builds options that will be passed to \code{waldo::compare()} down the line.
}
