% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_price_history.R
\name{get_price_history}
\alias{get_price_history}
\title{Get Price History}
\usage{
get_price_history(
  tokens,
  symbol,
  period_type = NULL,
  period = NULL,
  frequency_type = NULL,
  frequency = NULL,
  start_datetime = NULL,
  end_datetime = NULL,
  need_extended_hours_data = NULL,
  need_previous_close = NULL
)
}
\arguments{
\item{tokens}{token object from `get_authentication_tokens` function (list).}

\item{symbol}{equity symbol (string).}

\item{period_type}{chart period being requested. Can be "day", "month", "year", or "ytd". Default is NULL, which is "day" (string).}

\item{period}{number of chart period types. Default is NULL, which will then be dependent on the period type (numeric).}

\item{frequency_type}{the time frequency type. Default is NULL, which will then be dependent on the period type (string).}

\item{frequency}{the time frequency duration. Default is NULL, which is 1 (numeric).}

\item{start_datetime}{start datetime of request. Default is NULL, which is the end date less the period (datetime).}

\item{end_datetime}{end datetime of request. Default is NULL, which is the market close of the previous business day (datetime).}

\item{need_extended_hours_data}{indicator for whether extended hours data is needed. Default is NULL, which is TRUE (boolean).}

\item{need_previous_close}{indicator for whether the previous close price/date is needed. Default is NULL, which is FALSE (boolean).}
}
\value{
Returns a data frame containing information surrounding
        the price history of the symbol of interest.
}
\description{
Given the tokens object from the `get_authentication_tokens`
function and the equity symbol of interest, return the recent price
history for the symbol. There are additional parameters that
can be specified to customize the call, but specific information
about the default value information is given below (both in this
description and the specifics on each parameter).
}
\details{
While the parameter defaults for this function are NULL, the values
that ultimately feed into the API call are used behind-the-scenes.
For example, the period type parameter's default in the function is
NULL, but behind-the-scenes the API is using "day" to grab the
appropriate data.

Additionally, there are defaults for parameters that are dependent on
other parameters. For the period parameter, if the period type is "day",
the default period is 10, otherwise it is 1. For the frequency type
parameter, if it is "day" then the default value is "minute", otherwise
it is "monthly" for year and "weekly" for the others.
}
\author{
Nick Bultman, \email{njbultman74@gmail.com}, June 2024
}
\keyword{chain}
\keyword{expiration}
\keyword{option}
