% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolators.R
\name{cardinal_quintic_hermite}
\alias{cardinal_quintic_hermite}
\title{Cardinal Quintic Hermite Interpolator}
\usage{
cardinal_quintic_hermite(y, dydx, d2ydx2, x0, dx)
}
\arguments{
\item{y}{Numeric vector of ordinates (y-coordinates).}

\item{dydx}{Numeric vector of first derivatives (slopes) at each point.}

\item{d2ydx2}{Numeric vector of second derivatives at each point.}

\item{x0}{Numeric value of the first abscissa (x-coordinate).}

\item{dx}{Numeric value of the spacing between abscissas.}
}
\value{
An object of class \code{cardinal_quintic_hermite} with methods:
\itemize{
\item \code{spline(xi)}: Evaluate the interpolator at point \code{xi}.
\item \code{prime(xi)}: Evaluate the derivative of the interpolator at point \code{xi}.
\item \code{double_prime(xi)}: Evaluate the second derivative of the interpolator at point \code{xi}.
\item \code{domain()}: Get the domain of the interpolator.
}
}
\description{
Constructs a cardinal quintic Hermite interpolator given the vectors of ordinates, first derivatives, and second derivatives.
}
\examples{
y <- c(0, 1, 0)
dydx <- c(1, 0, -1)
d2ydx2 <- c(0, -1, 0)
x0 <- 0
dx <- 1
interpolator <- cardinal_quintic_hermite(y, dydx, d2ydx2, x0, dx)
xi <- 0.5
interpolator$spline(xi)
interpolator$prime(xi)
interpolator$double_prime(xi)
interpolator$domain()
}
