% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PyFunctions.R
\name{pyUploadDataFrame}
\alias{pyUploadDataFrame}
\title{Py Upload data.frame}
\usage{
pyUploadDataFrame(data, connection, table, schema)
}
\arguments{
\item{data}{data.frame}

\item{connection}{DatabaseConnector connection instance}

\item{table}{Table in database}

\item{schema}{database schema containing table reference}
}
\description{
Wrapper to python function to upload a data.frame using Postgres Copy functionality
}
\examples{
\dontrun{
connection <- DabaseConnector::connect(
  dbms = "postgreql",
  server = "myserver.com",
  port = 5432,
  password = "s",
  user = "me",
  database = "some_db"
)

ResultModelManager::pyUploadDataFrame(connection,
  table = "my_table",
  data.frame(id = 1:100, value = "some_value"),
  schema = "my_schema"
)
}
}
