% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolMesh.R
\name{interpolMesh}
\alias{interpolMesh}
\title{Interpolate values on a 3d mesh}
\usage{
interpolMesh(sur,values,refsur,refmat,element=c("triangles","vertices"),k=4)
}
\arguments{
\item{sur}{a reconstructed \code{mesh3d} object with vertices matching to
\code{refmat}.}

\item{values}{the vector of values related to \code{sur} to be interpolated.
\code{values} can be related to either triangles or vertices (see
\code{element}).}

\item{refsur}{the reference mesh (\code{mesh3d} object) to interpolate the
\code{values} on.}

\item{refmat}{the landmark set related to \code{refsur}.}

\item{element}{one of \code{"triangles"} or \code{"vertices"}, depending on
which of them \code{values} is related to.}

\item{k}{the number of nearest neighbor vertices used for interpolation (see
details).}
}
\value{
The vector of values related to each vertex of \code{refsur}.
}
\description{
The function takes a reconstructed \code{mesh3d} object
  (\code{sur}) with some related \code{values} (to either triangles or
  vertices of the mesh) and transfers such values to the real mesh
  (\code{refsur}) from which \code{sur} was derived.
}
\details{
The function starts by locating a set of points (NNps) on
  \code{refsur}, each being the single nearest neighbor for each vertex of
  \code{sur} (or barycenter if \code{element="triangles"}). Then,
  interpolation is performed by identifying the \code{k} points among NNps
  being the closest to each vertex of \code{refsur} and computing the mean of
  their \code{values} weighted by their distance.
}
\examples{
  \donttest{
  da<-"https://github.com/pasraia/RRmorph_example_data/raw/refs/heads/main/RRmorphdata.rda"
  download.file(url=da,destfile = paste0(tempdir(),"/RRmorphdata.rda"))
  load(paste0(tempdir(),"/RRmorphdata.rda"))

  require(rgl)
  require(Morpho)
  require(Rvcg)

  pca<-procSym(endo.set)
  ldm<-endo.set[,,"Homo_sapiens"]
  sur<-endo.sur[["Homo_sapiens"]]

  rec<- vcgBallPivoting(pca$mshape, radius = 0)
  rec$vb[1:3,]<-t(ldm)
  val1<-rnorm(ncol(rec$vb))

  # Interpolate values associated to vertices
  val1<-rnorm(ncol(rec$vb))
  interp1<-interpolMesh(sur = rec,refsur = sur,refmat = ldm,
                        values = val1,element ="vertices",k = 4)

  colmesh1<-col2mesh(mesh = sur,values = interp1,pal = heat.colors(5))
  open3d()
  shade3d(colmesh1,specular="black")


  # Interpolate values associated to triangles
  val2<-rnorm(ncol(rec$it))
  interp2<-interpolMesh(sur = rec,refsur = sur,refmat = ldm,
                        values = val2,element ="triangles",k = 4)

  colmesh2<-col2mesh(mesh = sur,values = interp2,pal = heat.colors(5))
  open3d()
  shade3d(colmesh2,specular="black")
  }
}
\author{
Marina Melchionna, Silvia Castiglione
}
