% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunMultiplePlp.R
\name{loadPlpAnalysesJson}
\alias{loadPlpAnalysesJson}
\title{Load the multiple prediction json settings from a file}
\usage{
loadPlpAnalysesJson(jsonFileLocation)
}
\arguments{
\item{jsonFileLocation}{The location of the file 'predictionAnalysisList.json' with the modelDesignList}
}
\value{
A list with the modelDesignList and cohortDefinitions
}
\description{
Load the multiple prediction json settings from a file
}
\details{
This function interprets a json with the multiple prediction settings and creates a list
that can be combined with connection settings to run a multiple prediction study
}
\examples{
modelDesign <- createModelDesign(targetId = 1, outcomeId = 2, 
                                 modelSettings = setLassoLogisticRegression())
saveLoc <- file.path(tempdir(), "loadPlpAnalysesJson")
savePlpAnalysesJson(modelDesignList = modelDesign, saveDirectory = saveLoc)
loadPlpAnalysesJson(file.path(saveLoc, "predictionAnalysisList.json"))
# clean use
unlink(saveLoc, recursive = TRUE)
}
