% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{oasis_dementia_mri_df}
\alias{oasis_dementia_mri_df}
\title{OASIS Aging-Dementia Longitudinal MRI}
\format{
A data frame with 373 observations and 15 variables:
\describe{
  \item{Subject.ID}{Character: Unique subject identifier}
  \item{MRI.ID}{Character: Unique MRI session identifier}
  \item{Group}{Factor with 3 levels: Diagnostic group classification}
  \item{Visit}{Integer: Visit number}
  \item{MR.Delay}{Integer: Days since first visit}
  \item{Gender}{Character: Subject gender}
  \item{Hand}{Character: Handedness}
  \item{Age}{Integer: Subject age in years}
  \item{EDUC}{Integer: Years of education}
  \item{SES}{Integer: Socioeconomic status}
  \item{MMSE}{Integer: Mini-Mental State Examination score (0-30)}
  \item{CDR}{Numeric: Clinical Dementia Rating (0-3)}
  \item{eTIV}{Integer: Estimated total intracranial volume (mm³)}
  \item{nWBV}{Numeric: Normalized whole brain volume}
  \item{ASF}{Numeric: Atlas scaling factor}
}
}
\source{
Data taken from the jointest package version 1.0. Original study:
Marcus, D.S. et al. (2007) Open Access Series of Imaging Studies (OASIS):
Cross-sectional MRI Data in Young, Middle Aged, Nondemented and Demented Older Adults.
\emph{Journal of Cognitive Neuroscience}, 19(9), 1498-1507.
}
\usage{
data(oasis_dementia_mri_df)
}
\description{
This dataset, oasis_dementia_mri_df, is a data frame containing longitudinal neuroimaging
and clinical data from 150 older adults (60-96 years) with repeated MRI scans over multiple
visits. The study includes both nondemented and demented individuals, with 373 total
imaging sessions featuring 3-4 T1-weighted scans per session.
}
\details{
The dataset name has been kept as 'oasis_dementia_mri_df' to avoid confusion
with other datasets in the R ecosystem. This naming convention helps distinguish
this dataset as part of the NeuroDataSets package. The suffix 'df' indicates
that the dataset is a data frame. The original content has not been modified.
}
