% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{create_predict_fun}
\alias{create_predict_fun}
\alias{create_predict_fun.Learner}
\title{Create a generic prediction function}
\usage{
create_predict_fun(model, task, predict.fun = NULL, type = NULL)

\method{create_predict_fun}{Learner}(model, task, predict.fun = NULL, type = NULL)
}
\arguments{
\item{model}{any \cr
An arbitrary trained clustering algorithm.}

\item{task}{\code{character(1)} \cr
Should be clustering in this case. To be extended...}

\item{predict.fun}{\code{function} \cr
The function to assign newdata. Only needed if \code{model} is not a model from
\code{mlr3cluster}. The first argument of \code{predict.fun} has to be the model, the
second the \code{newdata}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{function(model, newdata)
}\if{html}{\out{</div>}}

To be extended for more methods.}

\item{type}{\code{character(1)} \cr
For soft label predictions, \code{type="prob"}. For hard label predictions,
\code{type="partition"}. Consult the documentation or definition of the
clustering algorithm you use to find which type options you have.}
}
\value{
A unified cluster assignment function for either hard or soft labels.
}
\description{
Create the algorithms prediction function.
}
\section{Methods (by class)}{
\itemize{
\item \code{create_predict_fun(Learner)}: Create a predict function for algorithms from
\code{mlr3cluster}

}}
