% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{transMat}
\alias{transMat}
\title{Linear transformation matrix}
\usage{
transMat(R)
}
\arguments{
\item{R}{a correlation matrix}
}
\description{
Creates an m by m linear transformation matrix that
can be applied to n by m uncorrelated deviates
sampled from a standard normal distribution to produce
correlated deviates with an arbitrary correlation
of R. If R is not positive semi-definite, the function
returns smoothing and returns a warning (see details).
}
\details{
An eigendecomposition is applied to the correlation
matrix and used to test if it is positive semi-definite.
If the matrix is not positive semi-definite, it is not a
valid correlation matrix. In this case, smoothing is
applied to the matrix (as described in the 'cor.smooth' of
the 'psych' library) to obtain a valid correlation matrix.
The resulting deviates will thus not exactly match the
desired correlation, but will hopefully be close if the
input matrix wasn't too far removed from a valid
correlation matrix.
}
\examples{
# Create an 2x2 correlation matrix
R = 0.5*diag(2) + 0.5

# Sample 1000 uncorrelated deviates from a
# bivariate standard normal distribution
X = matrix(rnorm(2*1000), ncol=2)

# Compute the transformation matrix
T = transMat(R)

# Apply the transformation to the deviates
Y = X\%*\%T

# Measure the sample correlation
cor(Y)

}
