% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIGMArule.R
\name{SIGMArule}
\alias{SIGMArule}
\title{Parametric family of rules}
\usage{
SIGMArule(c, a = 0.5)
}
\arguments{
\item{c}{A numeric cost vector.}

\item{a}{A numeric value in the range [0,1], controlling the parameterization of the rule.
By default, \code{a = 0.5}.}
}
\value{
A numeric contribution vector, where each element represents the payment of the different agents.
}
\description{
\code{SIGMArule} calculates the contribution vector selected by a SIGMA rule.
}
\details{
Let \eqn{N^i_{-}=\{j\in N:j<i\}}. For each \eqn{a \in [0,1]}, each \eqn{c \in C^N}, and each \eqn{i \in N\backslash \{n\}}, a \eqn{\sigma^a} rule is defined by
\deqn{
\sigma^{a}_i(c)=\text{min}\Bigg\{\text{min}\bigg\{\dfrac{1}{r-(i-1)+a}\Big(c_r-\displaystyle\sum\limits_{j\in N^i_-}\sigma^{a}_{j}(c)\Big):r=i,\dots,n-1\bigg\},
\ \dfrac{1}{n+1-i}\Big(c_n-\displaystyle\sum\limits_{j\in N^i_-}\sigma_j^{a}(c)\Big)\Bigg\},}
\deqn{\text{and} \ \ \sigma_n^{a}(c)=c_n-\displaystyle\sum\limits_{i=1}^{n-1}\sigma_i^{a}(c).
}
In this rule, the closer the parameter \eqn{a} is to 0, the more equal the distribution of payments among the agents will be, and vice versa.
In fact, it is easy to verify that \eqn{\sigma^0=\text{CEC}\ \ \text{and} \ \ \sigma^1=\text{SM}}.
}
\examples{
c <- c(1, 3, 7, 10) # Cost vector
SIGMArule(c) # a=0.5

# The SIGMA rule with a=0 is the CEC rule
a <- 0
all.equal(SIGMArule(c, a), CECrule(c))

# The SIGMA rule with a=1 is the SM rule
a <- 1
all.equal(SIGMArule(c, a), SMrule(c))

}
\references{
Thomson, W. (2024). Cost allocation and airport problems.
\emph{Mathematical Social Sciences}, 31(C), 17–31.

van Gellekom, J. R. G. and Potters, J. A. M. (1999). Consistent solution rules for standard tree enterprises.
Technical Report 9910, University of Nijmegen.
}
\seealso{
\code{\link{CECrule}}, \code{\link{SMrule}}, \code{\link{basicrule}}, \code{\link{hierarchicalrule}}
}
