% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRIORrule.R
\name{PRIORrule}
\alias{PRIORrule}
\title{Priority family of rules}
\usage{
PRIORrule(c, order = NULL)
}
\arguments{
\item{c}{A numeric cost vector.}

\item{order}{A numeric vector indicating the priority order of agents when making contributions.
By default, agents follow their original indexing and contribute accordingly.}
}
\value{
A numeric contribution vector, where each element represents the payment of the different agents.
}
\description{
\code{PRIORrule} calculates the contribution vector selected by a priority rule.
}
\details{
For each \eqn{c \in C^N} and each \eqn{i \in N}, a priority rule relative to \eqn{\pi \in \Pi^N} is defined by
\deqn{
\text{P}^{\pi}_i(c)=\text{max}\Big\{0,\ c_i-\text{max}\{c_j:\pi(j)<\pi(i)\}\Big\}.
}
In this rule, each agent contributes at a different step, so that each one pays all that is necessary until reaching
the no-subsidy constraint. Consequently, the agents who arrive first cover the cost of all subsequent agents whose cost is lower.
}
\examples{
# Ascending order
c <- c(1, 3, 7, 10) # Cost vector
PRIORrule(c)

# Fluctuating order
c <- c(1, 3, 7, 10) # Cost vector
order <- c(2, 1, 4, 3) # Priority order
PRIORrule(c, order)

}
\references{
Bernárdez Ferradás, A., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2025). Airport problems with cloned agents. [Preprint manuscript].

Thomson, W. (2024). Cost allocation and airport problems.
\emph{Mathematical Social Sciences}, 31(C), 17–31.
}
\seealso{
\code{\link{NSfaces}}, \code{\link{basicrule}}, \code{\link{hierarchicalrule}}
}
