% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.R
\name{fileInput}
\alias{fileInput}
\title{File inputs}
\usage{
fileInput(
  id,
  placeholder = "Choose file",
  browse = "Browse",
  ...,
  multiple = TRUE,
  accept = NULL
)
}
\arguments{
\item{id}{A character string specifying the id of the reactive input.}

\item{placeholder}{A character string specifying the text inside the file
input, defaults to \code{"Choose file"}.}

\item{browse}{A character string specifying the label of file input, defaults
to \code{"Browse"}.}

\item{...}{Additional named arguments passed as HTML attributes to the
parent element or tag elements passed as child elements to the parent
element.}

\item{multiple}{One of \code{TRUE} or \code{FALSE} specifying whether or not the user
can upload multiple files at once, defaults to \code{TRUE}.}

\item{accept}{A character vector of possible MIME types or file extensions,
defaults to \code{NULL}, in which case any file type may be selected.}
}
\description{
Upload files to the server.
}
\section{\strong{Example} uploading a file}{
\if{html}{\out{<div class="R">}}\preformatted{shinyApp(
  ui = container(
    fileInput("upload") \%>\%
      margin(0, "auto", 0, "auto")
  ),
  server = function(input, output) \{
    observe(\{
      req(input$upload)

      print(input$upload)
    \})
  \}
)
}\if{html}{\out{</div>}}
}

\examples{

### Standard file input

fileInput(id = "file1")

### Adding a button

fileInput(
  id = "file2",
  left = buttonInput("upload", "Upload") \%>\%
    background("green")
)

### Customizing text

fileInput(
  id = "file3",
  placeholder = "Pick a file",
  browse = "Go go go!"
)

}
\seealso{
Other inputs: 
\code{\link{buttonGroupInput}()},
\code{\link{buttonInput}()},
\code{\link{checkbarInput}()},
\code{\link{checkboxInput}()},
\code{\link{chipInput}()},
\code{\link{formInput}()},
\code{\link{listGroupInput}()},
\code{\link{menuInput}()},
\code{\link{navInput}()},
\code{\link{radioInput}()},
\code{\link{radiobarInput}()},
\code{\link{rangeInput}()},
\code{\link{selectInput}()},
\code{\link{textInput}()}
}
\concept{inputs}
