% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webdeveloper.R
\name{create_options}
\alias{create_options}
\title{Creates HTML option tags for each position of a list of values and labels by calling HTML5::option(),
returning a string of HTML to pass to a select tag through HTML5::select().}
\usage{
create_options(x, selected = c(), add_blank = FALSE)
}
\arguments{
\item{x}{A vector which will become the value/label for each option. If named, names become values.}

\item{selected}{A value in the vector passed to mark as the initially selected option in the select tag.}

\item{add_blank}{Boolean, If TRUE, adds a blank option to the top of x.}
}
\value{
A string, with an option tag each row of x.
}
\description{
Creates HTML option tags for each position of a list of values and labels by calling HTML5::option(),
returning a string of HTML to pass to a select tag through HTML5::select().
}
\examples{
create_options(
x = c("New York", "Los Angeles", "Chicago"),
selected = "Chicago"
)
}
