% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tryCatchLog.R
\name{tryCatchLog}
\alias{tryCatchLog}
\title{Try an expression with condition logging and error handling}
\usage{
tryCatchLog(expr, ..., finally = NULL,
  write.error.dump.file = getOption("tryCatchLog.write.error.dump.file",
  FALSE),
  write.error.dump.folder = getOption("tryCatchLog.write.error.dump.folder",
  "."), silent.warnings = getOption("tryCatchLog.silent.warnings",
  FALSE), silent.messages = getOption("tryCatchLog.silent.messages",
  FALSE),
  include.full.call.stack = getOption("tryCatchLog.include.full.call.stack",
  TRUE),
  include.compact.call.stack = getOption("tryCatchLog.include.compact.call.stack",
  TRUE))
}
\arguments{
\item{expr}{expression to be evaluated}

\item{...}{condition handler functions (as in \code{\link{tryCatch}}).
Usual condition names are
\code{error}, \code{warning}, \code{message} and \code{interrupt}.
All condition handlers are passed to \code{\link{tryCatch}} as is
(no filtering, wrapping or changing of semantics).}

\item{finally}{expression to be evaluated at the end}

\item{write.error.dump.file}{\code{TRUE}: Saves a dump of the workspace and the call stack named
\code{dump_<YYYYMMDD>_at_<HHMMSS.sss>_PID_<process id>.rda}.
This dump file name pattern shall ensure unique file names in parallel processing scenarios.}

\item{write.error.dump.folder}{\code{path}: Saves the dump of the workspace in a specific folder instead of the working directory}

\item{silent.warnings}{\code{TRUE}: Warnings are logged only, but not propagated to the caller.\cr
\code{FALSE}: Warnings are logged and treated according to the global
setting in \code{\link{getOption}("warn")}. See also \code{\link{warning}}.}

\item{silent.messages}{\code{TRUE}: Messages are logged, but not propagated to the caller.\cr
\code{FALSE}: Messages are logged and propagated to the caller.}

\item{include.full.call.stack}{Flag of type \code{\link{logical}}:
Shall the full call stack be included in the log output? Since the full
call stack may be very long and the compact call stack has enough details
normally the full call stack can be omitted by passing \code{FALSE}.
The default value can be changed globally by setting the option \code{tryCatchLog.include.full.call.stack}.}

\item{include.compact.call.stack}{Flag of type \code{\link{logical}}:
Shall the compact call stack (including only calls with source code references)
be included in the log output? Note: If you ommit both the full and compact
call stacks the message text will be output without call stacks.
The default value can be changed globally by setting the option \code{tryCatchLog.include.compact.call.stack}.}
}
\value{
the value of the expression passed in as parameter "expr"
}
\description{
This function evaluates an expression passed in the \code{expr} parameter and executes
the error handler function passed as parameter \code{error} in case of an error condition.
}
\details{
The \code{finally} expression is then always evaluated at the end.

Conditions are logged with the function call stack (including file names and line numbers).

This function shall overcome some drawbacks of the standard \code{\link{tryCatch}} function.\cr
         For more details see \url{https://github.com/aryoda/tryCatchLog}.

         If the package \pkg{futile.logger} is installed it will be used for writing logging output,
         otherwise an internal basic logging output function is used.

         Before you call \code{tryCatchLog} for the first time you should initialize
         the logging framework you are using (e. g.\pkg{futile.logger} to control
         the log output (log to console or file etc.):

         \preformatted{  library(futile.logger)
  flog.appender(appender.file("my_app.log"))
  flog.threshold(INFO)    # TRACE, DEBUG, INFO, WARN, ERROR, FATAL}

         If you are using the \pkg{futile.logger} package \code{tryCatchLog} calls
         these log functions for the different R conditions to log them:

         \enumerate{
         \item error   -> \code{\link[futile.logger]{flog.error}}
         \item warning -> \code{\link[futile.logger]{flog.warn}}
         \item message -> \code{\link[futile.logger]{flog.info}}
         }

         \strong{`tryCatchLog` does only log the above conditions, other (user-defined)
         conditions are currently not not logged but can be catched of course
         by passing additional handler functions via the \code{...} argument.}

         The log contains the call stack with the file names and line numbers (if available).

         R does track source code references of scripts only if you set the option \code{keep.source} to TRUE via
         \code{options(keep.source = TRUE)}. Without this option this function cannot enrich source code references.

         If you use \command{Rscript} to start a non-interactive R script as batch job you
         have to set this option since it is FALSE by default. You can add this option to your
         \link{.Rprofile} file or use a startup R script that sets this option and sources your
         actual R script then.

         By default, most packages are built without source reference information.
         Setting the environment variable \code{R_KEEP_PKG_SOURCE=yes} before installing a source package
         will tell R to keep the source references. You can also use \code{options(keep.source.pkgs = TRUE)}
         before you install a package.

         Setting the parameter \code{tryCatchLog.write.error.dump.file} to TRUE allows a post-mortem analysis of the program state
         that led to the error. The dump contains the workspace and in the variable "last.dump"
         the call stack (\code{\link{sys.frames}}). This feature is very helpful for non-interactive R scripts ("batches").

         Setting the parameter \code{tryCatchLog.write.error.dump.folder} to a specific path allows to save the dump in a specific folder.
         If not set, the dump will be saved in the working directory.

         To start a post-mortem analysis after an error open a new R session and enter:
            \code{load("dump_20161016_164050.rda")   # replace the dump file name with your real file name
            debugger(last.dump)}

         Note that the dump does \bold{not} contain the loaded packages when the dump file was created
         and a dump loaded into memory does therefore \bold{not} use exactly the same search path.
         This means:

         \enumerate{
         \item{the program state is not exactly reproducible if objects are stored within a package namespace}
         \item{you cannot step through your source code in a reproducible way after loading the image
               if your source code calls functions of non-default packages}
         }
}
\section{Best practices}{


         To \bold{avoid that too many dump files filling your disk space} you should omit the \code{write.error.dump.file}
         parameter and instead set its default value using the option \code{tryCatchLog.write.error.dump.file} in your
         \link{.Rprofile} file instead (or in a startup R script that sources your actual script).
         In case of an error (that you can reproduce) you set the option to \code{TRUE} and re-run your script.
         Then you are able to examine the program state that led to the error by debugging the saved dump file.

         To see the \bold{source code references (source file names and line numbers)} in the stack traces you must
         set this option before executing your code:\cr
         \code{options(keep.source = TRUE)}

         You can \bold{execute your code as batch with \code{\link{Rscript}} using this shell script command}:\cr
         \code{Rscript -e "options(keep.source = TRUE); source('my_main_function.R')"}
}

\examples{
tryCatchLog(log(-1))   # logs a warning
}
\references{
\url{http://adv-r.had.co.nz/beyond-exception-handling.html}\cr
         \url{https://stackoverflow.com/questions/39964040/r-catch-errors-and-continue-execution-after-logging-the-stacktrace-no-tracebac}
}
\seealso{
\code{\link{tryLog}}, \code{\link{limitedLabels}}, \code{\link{get.pretty.call.stack}},
         \code{\link{getOption}}, \code{\link{last.tryCatchLog.result}},
         \code{\link{set.logging.functions}}
}
