% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_log_output.R
\name{build.log.output}
\alias{build.log.output}
\title{Creates a single string suited as logging output}
\usage{
build.log.output(log.results, include.full.call.stack = TRUE,
  include.severity = TRUE, include.timestamp = FALSE,
  use.platform.newline = FALSE)
}
\arguments{
\item{log.results}{A \code{data.frame} and member of the class \code{tryCatchLog.log.entry}
with log entry rows as returned by \code{\link{last.tryCatchLog.result}}
containing the logging information to be prepared for the logging output.}

\item{include.full.call.stack}{Flag of type \code{\link{logical}}:
Shall the full call stack be included in the log output? Since the full
call stack may be very long it can be omitted by passing \code{FALSE}.}

\item{include.severity}{\code{logical} switch if the severity level (e. g. ERROR) shall be
included in the output}

\item{include.timestamp}{\code{logical} switch if the timestamp of the catched condition shall be
included in the output}

\item{use.platform.newline}{\code{logical}: If \code{TRUE} the line breaks ("newline") will be
inserted according to the current operationg system (Windows: CR+LF,
else: CR). If \code{FALSE} R's usual \code{\\n} esacpe character will be inserted
and it is left to the client to convert this later into the operation-system-specific
characters. This argument is rarely required (except e. g. if you want to
write the return value into a database table column).}
}
\value{
A ready to use logging output with stack trace
              (as \code{character})
}
\description{
To view the formatted output print the logging output in a console use \code{\link{cat}}
(instead of printing the output with \code{\link{print}} which shows the newline escape codes).
}
\note{
Supports also a single row created by the package internal function \code{\link{build.log.entry}}
              as \code{log.results} argument.
}
\seealso{
\code{\link{last.tryCatchLog.result}}
              \code{\link{build.log.entry}}
}
