% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{set_options}
\alias{set_options}
\title{Set Default Options for \pkg{treePlotArea}}
\usage{
set_options(...)
}
\arguments{
\item{...}{See \code{\link[fritools:set_options]{fritools::set_options}}.
Leave empty to initialize the defaults if need be.}
}
\value{
See \code{\link[fritools:set_options]{fritools::set_options}}.
}
\description{
This is just a convenience wrapper to
\code{\link[fritools:set_options]{fritools::set_options}}.
\pkg{treePlotArea} has a set of default options to define the columns of the
\code{\link{data.frame}s} that are passed to
\code{\link{get_correction_factors}}.
See \code{\link{get_defaults}} for a description of these options.
}
\examples{
# Set the default
set_options()
getOption("treePlotArea")
# Overwrite some
option_list <- list(angle_counts = list(dbh = "diameter"),
                    boundaries = list(boundary_status = "boundart_stat"))
set_options(angle_counts = option_list[["angle_counts"]],
            boundaries = option_list[["boundaries"]])
getOption("treePlotArea")$angle_counts$dbh
# restore default
option_list <- get_defaults()
set_options(angle_counts = option_list[["angle_counts"]],
            boundaries = option_list[["boundaries"]])
getOption("treePlotArea")$angle_counts$dbh
}
\seealso{
Other option functions: 
\code{\link{get_defaults}()}
}
\concept{option functions}
