% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_beast_posterior.R
\name{parse_beast_posterior}
\alias{parse_beast_posterior}
\title{Parses BEAST2 output files to a posterior}
\usage{
parse_beast_posterior(trees_filenames, log_filename)
}
\arguments{
\item{trees_filenames}{one or more names of the BEAST2 .trees output files.
A BEAST2 run will create as much .trees files as there are alignments}

\item{log_filename}{name of the BEAST2 .trees output file}
}
\value{
a list with the following elements:\cr
  \itemize{
    item{\code{estimates}: parameter estimates}
    item{
      \code{[alignment_id]_trees}: the phylogenies in the
      BEAST2 posterior. \code{[alignment_id]} is the ID
      of the alignment.
    }
  }
}
\description{
Parses BEAST2 output files to a posterior
}
\examples{
  trees_filenames <- get_tracerer_path("beast2_example_output.trees")
  log_filename <- get_tracerer_path("beast2_example_output.log")
  posterior <- parse_beast_posterior(
    trees_filenames = trees_filenames,
    log_filename = log_filename
  )
  testit::assert(is_posterior(posterior))
}
\seealso{
Use \code{\link{remove_burn_ins}} to remove the burn-ins from
  the posterior's estimates (\code{posterior$estimates})
}
\author{
Richèl J.C. Bilderbeek
}
